/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.rules;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.rules.VWRulesPropertyPanel;
import filenet.vw.apps.taskman.rules.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWRulesNode
extends VWTaskBaseNode {
    private VWRulesPropertyPanel m_propertyPanel = null;
    private boolean m_isStarted = false;
    private byte[] STOP_COMMAND = null;
    private byte[] PING_COMMAND = null;
    private int m_portNumber = 32774;
    private String m_classPath = null;
    private String m_propertyFile = null;
    private String m_javaArgs = null;
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("rules_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("rules_16.gif");
    protected static final ImageIcon nodeIconS32 = VWImageLoader.createImageIcon("rules_stop_32.gif");
    protected static final ImageIcon nodeIconS16 = VWImageLoader.createImageIcon("rules_stop_16.gif");
    private static final String ASCII = "US-ASCII";
    private static final String SUCCESS_RESPONSE = "[01c][e]";
    private static final String COMMAND_DELIM = ":";
    private static final String S_STOP_COMMAND = "[01C]Q[e]";
    private static final String S_PING_COMMAND = "[01C]P[e]";
    private static final int DEFAULT_PORT = 32774;
    public static final String XML_NODE_NAME = "RulesEngine";

    public VWRulesNode(String propertiesPath) throws Exception {
        super(VWResource.RulesEngine, propertiesPath, "TaskManager.RulesEngine", 21);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.fromXML(this.getXMLHandler());
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWRulesPropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, true);
        }
        this.STOP_COMMAND = this.getCommandBytes(S_STOP_COMMAND);
        this.PING_COMMAND = this.getCommandBytes(S_PING_COMMAND);
    }

    public void refresh() {
        try {
            String result = (String)this.lookupProcess();
            boolean bl = this.m_isStarted = result != null && result.equals(SUCCESS_RESPONSE);
            if (!VWTaskCore.getInstance().isAutoMode()) {
                this.m_propertyPanel.refresh();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public void start() throws Exception {
        this.refresh();
        if (!this.isStarted()) {
            VWTaskProcessResult result;
            this.writeMessage(Level.INFO, VWResource.StartingRulesEngine);
            StringBuffer command = new StringBuffer("filenet.rules.daemon.RulesServer -p " + this.m_portNumber);
            String additionalArgs = this.getProperty("TaskManager.RulesEngine.Args", null);
            if (additionalArgs != null && additionalArgs.length() > 0) {
                command.append(" " + additionalArgs);
            }
            ArrayList<String> javaArgs = new ArrayList<String>();
            StringBuffer cp = new StringBuffer(this.m_classPath);
            cp.append(File.pathSeparator);
            cp.append(System.getProperty("java.class.path"));
            javaArgs.add("-cp");
            javaArgs.add(cp.toString());
            javaArgs.add("-Dfnrules.properties=" + this.m_propertyFile);
            if (this.m_javaArgs != null && this.m_javaArgs.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(this.m_javaArgs);
                while (tokens.hasMoreTokens()) {
                    javaArgs.add(tokens.nextToken());
                }
            }
            if ((result = VWTaskProcessLauncher.launchJavaServer(javaArgs, command.toString(), true, null, this)).getResult() == null || !((String)result.getResult()).equals(SUCCESS_RESPONSE)) {
                if (result.getError().length() > 0) {
                    throw new Exception(result.getError());
                }
                throw new Exception(result.getOutput());
            }
            this.writeMessage(Level.INFO, VWResource.RulesEngineStarted);
            this.m_isStarted = true;
        }
    }

    public void stop() throws VWException, IOException {
        if (!this.isStarted()) {
            return;
        }
        this.writeMessage(Level.INFO, VWResource.StoppingRulesEngine);
        Socket socket = null;
        try {
            socket = this.getSocketConnection();
        }
        catch (IOException e) {
            VWDebug.logInfo("VWRulesNode::stop() - " + e.getLocalizedMessage());
        }
        if (socket != null) {
            OutputStream os = socket.getOutputStream();
            os.write(this.STOP_COMMAND);
            os.flush();
            String result = this.getResult(socket.getInputStream());
            if (result == null || !result.equals(SUCCESS_RESPONSE)) {
                throw new VWException("vw.apps.taskman.rules.InvalidPingResponse", "Invalid response from Rules Listener: {0}", result);
            }
        }
        this.m_isStarted = false;
        this.writeMessage(Level.INFO, VWResource.RulesEngineStopped);
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
        }
    }

    public boolean isStarted() {
        return this.m_isStarted;
    }

    public int getPortNumber() {
        return this.m_portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.m_portNumber = portNumber;
    }

    public String getClassPath() {
        return this.m_classPath;
    }

    public void setClassPath(String path) {
        this.m_classPath = path;
    }

    public String getPropertyFile() {
        return this.m_propertyFile;
    }

    public void setPropertyFile(String file) {
        this.m_propertyFile = file;
    }

    public String getJavaArgs() {
        return this.m_javaArgs;
    }

    public void setJavaArgs(String args) {
        this.m_javaArgs = args;
    }

    public Icon getIcon16() {
        if (this.isStarted()) {
            return nodeIcon16;
        }
        return nodeIconS16;
    }

    public Icon getIcon32() {
        if (this.isStarted()) {
            return nodeIcon32;
        }
        return nodeIconS32;
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "rules.htm");
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        theBuffer.append("\t<RulesEngine\n");
        theBuffer.append(ATTRIB_INDENT + this.getAutoStartAttributeString() + "\n");
        theBuffer.append(ATTRIB_INDENT + "ClassPath=\"" + VWTaskXMLHandler.toXMLString(this.m_classPath) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "PropertyFile=\"" + VWTaskXMLHandler.toXMLString(this.m_propertyFile) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "JavaArgs=\"" + VWTaskXMLHandler.toXMLString(this.m_javaArgs) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Port=\"" + this.m_portNumber + "\"/>\n");
    }

    private void fromXML(VWTaskXMLHandler xmlHandler) {
        try {
            Node node;
            Element ele = null;
            if (xmlHandler != null && (node = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), XML_NODE_NAME)) != null && node.getNodeType() == 1) {
                ele = (Element)node;
            }
            if (ele != null) {
                this.setAutoStartEnabled(ele);
            }
            if (this.hasValue(ele, "Port")) {
                try {
                    this.setPortNumber(Integer.parseInt(ele.getAttribute("Port")));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.setPortNumber(this.readPortFromFNRulesProperties());
            }
            if (this.hasValue(ele, "ClassPath")) {
                this.setClassPath(ele.getAttribute("ClassPath"));
            } else {
                this.setClassPath(this.getProperty("TaskManager.RulesEngine.ClassPath", ""));
            }
            if (this.hasValue(ele, "PropertyFile")) {
                this.setPropertyFile(ele.getAttribute("PropertyFile"));
            } else {
                this.setPropertyFile(this.getProperty("TaskManager.RulesEngine.Props", ""));
            }
            if (this.hasValue(ele, "JavaArgs")) {
                this.setJavaArgs(ele.getAttribute("JavaArgs"));
            } else {
                this.setJavaArgs(this.getProperty("TaskManager.RulesEngine.VMArgs", ""));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasValue(Element ele, String attribute) {
        return ele != null && ele.getAttributeNode(attribute) != null && !ele.getAttribute(attribute).equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupProcess() throws Exception {
        String result = null;
        Socket socket = null;
        OutputStream os = null;
        try {
            this.m_isStarted = false;
            VWDebug.logInfo("Pinging rules listener.");
            socket = this.getSocketConnection();
            os = socket.getOutputStream();
            os.write(this.PING_COMMAND);
            os.flush();
            result = this.getResult(socket.getInputStream());
        }
        catch (IOException ex) {
            VWDebug.logInfo("VWRulesNode::lookupProcess() - " + ex.getLocalizedMessage());
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
        return result;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
                this.start();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
                this.stop();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.START, VWTaskActionCommand.STOP, "Add Separator", VWTaskActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
            return this.showStartIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
            return this.showStopIcon();
        }
        return true;
    }

    public boolean showStartIcon() {
        return !this.isStarted();
    }

    public boolean showStopIcon() {
        return this.isStarted();
    }

    public boolean showDeleteIcon() {
        return false;
    }

    private Socket getSocketConnection() throws VWException, IOException {
        Socket socket = new Socket("localhost", this.m_portNumber);
        socket.setTcpNoDelay(true);
        return socket;
    }

    private String getResult(InputStream is) throws IOException {
        String result = null;
        byte[] bytes = new byte[1024];
        is.read(bytes);
        result = new String(bytes, ASCII).trim();
        VWDebug.logInfo("Command result: " + result);
        int delimIndex = result.indexOf(COMMAND_DELIM);
        if (delimIndex != -1 && result.length() > 1) {
            result = result.substring(delimIndex + 1);
        }
        return result;
    }

    private byte[] getCommandBytes(String command) throws Exception {
        byte[] delim = COMMAND_DELIM.getBytes(ASCII);
        byte[] cmd = new String(command).getBytes(ASCII);
        byte[] cmdLen = new String("" + cmd.length).getBytes(ASCII);
        byte[] cmdBytes = new byte[cmdLen.length + delim.length + cmd.length];
        System.arraycopy(cmdLen, 0, cmdBytes, 0, cmdLen.length);
        System.arraycopy(delim, 0, cmdBytes, cmdLen.length, delim.length);
        System.arraycopy(cmd, 0, cmdBytes, cmdLen.length + delim.length, cmd.length);
        return cmdBytes;
    }

    private int readPortFromFNRulesProperties() throws VWException {
        String S_RULES_ENGINE_PORT = "defaultport";
        int port = 32774;
        String propsPath = this.getProperty("TaskManager.RulesEngine.Props", "");
        File propertiesFile = new File(propsPath);
        if (!propertiesFile.exists()) {
            throw new VWException("vw.apps.taskman.rules.VWRulesPropertyPanel.PropsFileDoesNotExist", "Could not locate {0} properties file: " + propsPath, VWResource.RulesEngine);
        }
        FileInputStream propFile = null;
        try {
            propFile = new FileInputStream(propsPath);
            Properties properties = new Properties();
            properties.load(propFile);
            try {
                port = Integer.parseInt(properties.getProperty(S_RULES_ENGINE_PORT, ""));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        catch (Exception e) {
            throw new VWException("vw.apps.taskman.rules.VWRulesPropertyPanel.ErrorReadingPropsFile", "Error reading {0} properties file " + propsPath + " : {1}", VWResource.RulesEngine, e.getLocalizedMessage());
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                    propFile = null;
                }
                catch (Exception e) {}
            }
        }
        return port;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   24 Aug 2006 17:04:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   mdwane  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.15  $";
    }
}

